clc
clear all
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultLegendInterpreter','latex'); %trying to set the default
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');
linea=2;
%% Physical parameters
Rg=298.053; %Costante dell'aria (J/kg/K)
Temp=293;                  %Temperature (K)
% Calcolo della viscosit dinamica dell'aria in funzione della temperatura
% Costanti di Sutherland per l'aria
mu0 = 1.716e-5;    % Viscosit a 273.15 K (Pas)
T0 = 273.15;       % Temperatura di riferimento (K)
S = 110.4;         % Costante di Sutherland (K)
% Equazione di Sutherland
mu = mu0 * (Temp / T0)^(3/2) * (T0 + S) / (Temp + S);
pa=101325;
ps=3e5;                 %Supply pressure absolute (Pa)
rho=pa/(Rg*Temp);
dt=3e-7;                %Time Step (s)
cG=60000/rho;
%Definizione numero elementini nelle due direzioni
M=30; %nodi incogniti -2 direzione radiale
N=30;%nodi incogniti direzione circonferenziale
%Geometrical parameters
R2 =31.5e-3 ;  % outer radius (m)
R1 =2*R2/(M-1); % inner radius (m)

dr=(R2-R1)/(M-1);
dtheta=(2*pi)/(N-1);
nR =linspace(R1,R2,M); %Vettore dei raggi
nT =linspace(0,2*pi-dtheta,N);%Vettore degli angoli
nT=[nT(end), nT, nT(1)];

permeability=1.25*1e-15; %permeabilit (m^2)
L=6e-3;     %spessore strato poroso (m)
omega=0;
[Theta,R] = meshgrid(nT,nR) ; %crea le coordinate di tutti i punti %nR lo replica su ogni riga %nT su ogni colonna
% Convert grid to cartesian coordintes
Y =- R.*cos(Theta); 
X= R.*sin(Theta);
%Variable Initialization
Pin=pa;
Pold=ones(M,N+2)*Pin; 
Gi_new=ones(M,N+2)*Pin; 
GN=ones(M,N+2)*Pin; 
GS=ones(M,N+2)*Pin; 
gO=ones(M,N+2)*Pin; 
gE=ones(M,N+2)*Pin; 
Gout=ones(M,N+2)*Pin; 


Pnew=Pold;
pc0=Pin;
H0=5:1:25;

        Time=[];
        Fpt=[];
        Gint=[];
        Goutt=[];
        Err_F=[];
        Err_G=[];
        Err_P=[];


for ind_h=1:length(H0)
    tic  
   
    h0c=H0(ind_h)*1e-6;
    h0c_dot=0;
    h0=ones(size(Pold))*h0c;
    h0_dot=zeros(size(h0));
    err_P=10;
    err_G=10;
    err_F=10;
    no_punti=10000;


    iter=0;
    contatore=0;
    t=0;
    toll_F=1e-5;
    toll_G=1e-4;
    F1=0;
    pc1=pc0;

   while abs(err_G)>toll_G || abs(err_F)>toll_F
    iter=iter+1;
    t=t+dt;
    contatore=contatore+1;
    F0=F1;
    Pold=Pnew;
    pc0=pc1;


    jj=[2:N+1];   ii=[2:M-1]; %Nodi interni
    %Nodi interni
    %Calcolo portata in ingresso nodi
    Gi_new(ii,jj)=((ps^2-Pold(ii,jj).^2).*permeability.*R(ii,jj)*dr*dtheta)/(2*mu*Rg*Temp*L);
    %Calcolo portata radiale
    GN(ii,jj)=-(Pold(ii-1,jj).*h0(ii-1,jj).^3.*R(ii-1,jj)+Pold(ii,jj).*h0(ii,jj).^3.*R(ii,jj))./(24*mu*Rg*Temp*dr).*(Pold(ii,jj)-Pold(ii-1,jj));
    GS(ii,jj)=-(Pold(ii,jj).*h0(ii,jj).^3.*R(ii,jj)+Pold(ii+1,jj).*h0(ii+1,jj).^3.*R(ii+1,jj))./(24*mu*Rg*Temp*dr).*(Pold(ii+1,jj)-Pold(ii,jj));
    %Calcolo portata circonferenziale
    gO(ii,jj)=-(Pold(ii,jj-1).*h0(ii,jj-1).^3+Pold(ii,jj).*h0(ii,jj).^3)./(12*mu*Rg*Temp*(R(ii,jj-1)+R(ii,jj))).*(Pold(ii,jj)-Pold(ii,jj-1))/dtheta+omega.*(Pold(ii,jj-1).*h0(ii,jj-1).*R(ii,jj-1)+Pold(ii,jj).*h0(ii,jj).*R(ii,jj))/(4*Rg*Temp);
    gE(ii,jj)=-(Pold(ii,jj).*h0(ii,jj).^3+Pold(ii,jj+1).*h0(ii,jj+1).^3)./(12*mu*Rg*Temp*(R(ii,jj)+R(ii,jj+1))).*(Pold(ii,jj+1)-Pold(ii,jj))/dtheta+omega.*(Pold(ii,jj).*h0(ii,jj).*R(ii,jj)+Pold(ii,jj+1).*h0(ii,jj+1).*R(ii,jj+1))/(4*Rg*Temp);
    Gout(ii,jj)=((GS(ii,jj)-GN(ii,jj))*dtheta+(gE(ii,jj)-gO(ii,jj))*dr);%portante uscenti positive
    %Calcolo pressione meato da equazione di continuit
    Pnew(ii,jj)=Pold(ii,jj)+((Gi_new(ii,jj)-Gout(ii,jj))./(R(ii,jj)*dtheta*dr)-Pold(ii,jj).*h0_dot(ii,jj)./(Rg*Temp)).*(dt*Rg*Temp)./(h0(ii,jj));

    %Calcolo errore
    err_P=abs(max((Pnew(:)-Pold(:))./Pold(:)));
    Err_P(iter)=err_P;
    %Diverge?
    if any(isnan(Pnew(:))) || any(isinf(Pnew(:)))
        fprintf('Iterations diverge\n');
        return;
    end
    %Equazioni relative al volume centrale
    Ac=(pi*R1^2)/(N-1); %Area di uno spicchio
    %Calcolo della portata normale (singoli spicchi)
    Gi_new(1,jj)=(ps^2-Pold(1,jj).^2).*(permeability*Ac)./(2*mu*Rg*Temp*L);
    %Calcolo portata radiale (singoli spicchi)
    GS(1,jj)=-(Pold(1,jj).*h0(1,jj).^3.*R(1,jj)+Pold(2,jj).*h0(2,jj).^3.*R(2,jj))./(24*mu*Rg*Temp*dr).*(Pold(2,jj)-Pold(1,jj));
    %Calcolo portata circonferenziale (singoli spicchi)
    gO(1,jj)=-(Pold(1,jj-1).*h0(1,jj-1).^3+Pold(1,jj).*h0(1,jj).^3)./(12*mu*Rg*Temp*(R(1,jj-1)+R(1,jj))).*(Pold(1,jj)-Pold(1,jj-1))/dtheta+omega.*(Pold(1,jj-1).*h0(1,jj-1).*R(1,jj-1)+Pold(1,jj).*h0(1,jj).*R(1,jj))/(4*Rg*Temp);
    gE(1,jj)=-(Pold(1,jj).*h0(1,jj).^3+Pold(1,jj+1).*h0(1,jj+1).^3)./(12*mu*Rg*Temp*(R(1,jj)+R(1,jj+1))).*(Pold(1,jj+1)-Pold(1,jj))/dtheta+omega.*(Pold(1,jj).*h0(1,jj).*R(1,jj)+Pold(1,jj+1).*h0(1,jj+1).*R(1,jj+1))/(4*Rg*Temp);
    Gout(1,jj)=(GS(1,jj)*dtheta+(gE(1,jj)-gO(1,jj))*dr);%portante uscenti positive
    %Equazione di continuit applicata al volume centrale (singoli spicchi)
    Pnew(1,jj)=Pold(1,jj)+((Gi_new(1,jj)-Gout(1,jj))-Pold(1,jj).*h0_dot(1,jj).*Ac./(Rg*Temp)).*(dt*Rg*Temp)./(h0(1,jj).*Ac);

    %Boundary conditions Periodicity
    Pnew(:,1)=Pnew(:,N+1);
    Pnew(:,N+2)=Pnew(:,2);

    % calcolo della capacit di carico
    Fc=sum(Pnew(1,jj)*Ac); %volume centrale
%      Fc=0;
    F1=sum((Pnew(ii,jj)-pa)*dr*dtheta.*R(ii,jj),'all')+Fc;
    err_F=(F1-F0)/F0;
    Err_F(iter)=err_F;
    %Calcolo della portata in ingresso
    G1in=sum(Gi_new(1:M-1,jj),'all');
    %Calcolo della portata in uscita O-N-E-S
    G1out=sum(Gout(1:M-1,jj),'all');
    err_G=(G1in-G1out)/G1in;
    Err_G(iter)=err_G; 
       
        if contatore==no_punti
        Time=[Time t];
        Fpt=[Fpt F1];
        Gint=[Gint G1in];
        Goutt=[Goutt G1out];
        Err_F=[Err_F err_F];
        Err_G=[Err_G err_G];
        Err_P=[Err_P err_P];
           
        contatore=0;             
    end
    
    

    end
    toc
    Fp(ind_h)=F1;
    Qin(ind_h)=G1in*cG;
    Qout(ind_h)=G1out*cG;


    figure
%     plot(Err_P),hold on
    plot(Err_F,'ro'),hold on
    plot(Err_G,'b'),hold on
    xlabel('iterations'),ylabel('Error'),grid on  
    pause(0.5)


    figure
    surf(X(:,2:end)*1e3,Y(:,2:end)*1e3,Pnew(:,2:end)), hold on
    %    surf(0*1e3,0*1e3,mean(pc)), hold on
    xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Pressure (Pa)')
    pause(0.5)
end

%% 
Test=1;
p_rel=(ps*1e-5)-1; %bar
shift=2;
Caricamento=['load Statica_NW_D65_ps' num2str(p_rel*100) '_' num2str(Test)];
eval(Caricamento)

%portanza
figure               
plot(H0(1:length(Qin)),Fp,'r','linewidth',linea),hold on
Forza=['plot(h_NW' num2str(p_rel*100) '_' num2str(Test) '+shift,F_NW' num2str(p_rel*100) '_' num2str(Test) ', ''ko''), hold on'];
eval(Forza)
legend('Numerical','Experimental')   
xlabel('Air gap height ($\mu m$)'),ylabel('Force (N)')
grid on, zoom on
xlim([5 25])
%portata    
figure 
plot(H0(1:length(Qin)),Qin,'bo'),hold on 
plot(H0(1:length(Qin)),Qout,'r'),hold on 
Portata=['plot(h_NW' num2str(p_rel*100) '_' num2str(Test) '+shift,Q_NW' num2str(p_rel*100) '_' num2str(Test) ', ''ko''), hold on'];
eval(Portata)  
xlabel('Air gap height ($\mu m$)'),ylabel('Flow (l/min) ANR 20 $^{\circ}$'),
legend('Numerical-Q_{in}','Numerical-Q_{out}','Experimental')
grid on
xlim([5 25])
%rigidezza
ks=-derivata(Fp,H0);
figure 
plot(H0(1:length(Qin)),ks,'r'),hold on 
rigidezza=['plot(h_NW' num2str(p_rel*100) '_' num2str(Test) '(100:end-400)+shift,ks_NW' num2str(p_rel*100) '_' num2str(Test) '(100:end-400), ''ko''), hold on'];
eval(rigidezza) 
xlabel('Air gap height ($\mu m$)'),ylabel('Stiffness ($\frac{N}{\mu m}$)'),
legend('Numerical','Experimental')
grid on
% xlim([5 25]),ylim([0 50])

meato=['h' num2str(p_rel*100) '=H0;'];
Forza=['F' num2str(p_rel*100) '=Fp;'];
Portata_in=['Qin' num2str(p_rel*100) '=Qin;'];
Portata_out=['Qout' num2str(p_rel*100) '=Qout;'];
stiffness=['ks' num2str(p_rel*100) '=ks;'];
eval(meato)
eval(Forza)
eval(Portata_in)
eval(Portata_out)
eval(stiffness)

salva=['save Modello_Statico_NW_D65_ps' num2str(p_rel*100) ' h' num2str(p_rel*100) ' F' num2str(p_rel*100) ...
        ' Qin' num2str(p_rel*100) ' Qout' num2str(p_rel*100)  ' ks' num2str(p_rel*100) ];

   eval(salva)

   